
package eu.doppelhelix.jna.test.gc;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.platform.linux.LibC;
import java.lang.reflect.Proxy;
import java.nio.charset.StandardCharsets;

public class DemoThread implements Runnable {
    public void run() {
        System.out.println("===================");
        LibC libc = Native.load("c", LibC.class);
        byte[] data = new byte[1024];
        libc.gethostname(data, data.length - 1);
        System.out.println("=== Hostname: " + new String(data, StandardCharsets.UTF_8));
        System.out.println("===================");
        Library.Handler lh = (Library.Handler) Proxy.getInvocationHandler(libc);
        lh.getNativeLibrary().close();
    }
}
