
package eu.doppelhelix.jna.test.gc;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 * @author matthias
 */
public class Test {

    private static final Logger CLEANER_LOGGER = Logger.getLogger("com.sun.jna.internal.Cleaner");
    private static volatile byte[] data = null;

    public static void main(String[] args) throws Exception {
        String pathToJNADevBuildBase = "/home/matthias/src/jnalib/";
        boolean exit = false;
        CLEANER_LOGGER.setLevel(Level.FINEST);
        for(Handler h: Logger.getLogger("").getHandlers()) {
            h.setLevel(Level.ALL);
        }
        URLClassLoader classLoader = new URLClassLoader(new URL[] {
                Test.class.getProtectionDomain().getCodeSource().getLocation(),
                new File(pathToJNADevBuildBase + "build/jna.jar").toURI().toURL(),
                new File(pathToJNADevBuildBase + "contrib/platform/dist/jna-platform.jar").toURI().toURL()
        }, null);
        ((Runnable) classLoader.loadClass("eu.doppelhelix.jna.test.gc.DemoThread").getConstructor().newInstance()).run();
        while(true) {
            data = new byte[102400];
            Thread.sleep(100);
            if(exit) {
                break;
            }
        }
        ((Runnable) classLoader.loadClass("eu.doppelhelix.jna.test.gc.DemoThread").getConstructor().newInstance()).run();
        exit = false;
        while(true) {
            data = new byte[102400];
            Thread.sleep(100);
            if(exit) {
                break;
            }
        }
    }
}
